# GradConf

This is the official implementation for the GradConf.

GradConf are developed based on [AI4Risk](https://github.com/AI4Risk/antifraud/tree/main?tab=readme-ov-file), a financial fraud detection framework.

## **Dependencies**

---

Please check the requirements.yaml file in the directory.

## **Data processing**

---

**Downloading datasets:** please see [AI4Risk](https://github.com/AI4Risk/antifraud/tree/main?tab=readme-ov-file).

**For downloading S-FFSD for BWGNN and H2-FDetector with GradConf:**

Please download it at this anonymous [link](https://anonymous.4open.science/r/nipsdata-9587/). 

Put ffsd.dgl into `methods\H2-FDetector\data` and graph-S-FFSD.bin into `methods\BWGNN\dataset` .

**Processing steps:**

- **For HOGRL, GTAN, RGTAN with GradConf:** For processing steps of the datasets Amazon, YelpChi, and S-FFSD, please see [AI4Risk](https://github.com/AI4Risk/antifraud/tree/main?tab=readme-ov-file).
- **For BWGNN with GradConf:**  For  processing steps of the datasets Amazon and YelpChi, please see [BWGNN](https://github.com/squareRoot3/Rethinking-Anomaly-Detection/tree/master).
- **For H2-FDetector with GradConf:**  For processing steps of the datasets Amazon, YelpChi, please see [H2-FDetector](https://github.com/shifengzhao/H2-FDetector).
- **For processing steps of S-FFSD on BWGNN and H2-FDetector with GradConf:** The data preprocessing of S-FFSD has been completed in the code folder, and only the training command needs to be run.

## **Training & Evalutaion**

---

For the hyperparameter configuration of the three datasets on GradConf , see config in the code folder or paper.

Train GradConf on HOGRL:

```python
python main.py --method hogrl_GradConf
```

Train GradConf on GTAN:

```python
python main.py --method gtan_dual
```

Train GradConf on RGTAN:

```python
python main.py --method rgtan_dual
```

Train GradConf on BWGNN:

```python
cd methods/BWGNN
python main_dual.py --dataset amazon --train_ratio 0.4 --hid_dim 64 \
--order 2 --homo 1 --epoch 100 --run 1
python main_dual.py --dataset yelp --train_ratio 0.01 --hid_dim 64 \
--order 2 --homo 0 --epoch 100 --run 1
python main_dual.py --dataset s-ffsd --train_ratio 0.4 --hid_dim 64 \
--order 2 --homo 1 --epoch 100 --run 1
```

Train H2-FDetector:

```python
cd methods/H2-FDetector/src
python train_dual.py --dataset amazon
python train_dual.py --dataset yelp
python train_ffsd.py
```

## **Test Result**

---

![image.png](image.png)